#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <math.h>
#include "ptimes.h"

#define IDM_PRAYING_TIMES              50000
#define IDM_HIJRI_GREGORIAN_DATE       50001

#define MAXNAMEL   40
#define DPR        (57.29577951308230876799)/* degree per radian (180/pi) */
#define RPD        (0.01745329251994329577) /* radians per degree (pi/180) */
#define HPR        (3.81971863420548805845) /* hours per radian (12/pi) */
#define FABS(a)    ((a) > 0 ? (a) : -(a))
#define FMOD(a,b)  ((a) - floor( (a)/(b) ) * (b))
#define MAXENV     9
#define NULLP      ((char *)0)

char strVarious[512];
HINSTANCE hInst;
HWND hwndMain, hwndButtonTimes, hwndButtonDate;

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// DATA FOR CREATING PRAYING TIMES
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

// THIS IS THE NAME OF THE FILE WHERE PRAYING TIMES DATA WILL BE SAVED
// DIRECTORY YOU DO NOT NEED TO TYPE BECOUSE FILE WILL BE SAVED AT THE CURRENT
// DIRECTORY FROM WHERE YOU WERE STARTED THIS PROGRAM
char SavingFileName[256] = "PrayingTimes.txt";

// NAME OF THE DEFAULT PRAYING TIME DATA
char nameTime[256]= {"Crotia, Zagreb"};

//DEFAULT PRAYING TIME DATA - HERE YOU CAN CHANGE DATA TO YOUR LOCATION
//YOUR LOCATION FROM MEKKA IN SAUDI ARABIA
//if your location is north from Mekka then select north
int north                = TRUE;
//else select south
int south                = FALSE;
//if your location in nearest to Mekka from the east then select east
int east                 = TRUE;
//else select west
int west                 = FALSE;
//DALYLIGHT changing times - if in your country was changing time,
// 1 hour + or - at the specific month then select TRUE.
int dstAval              = TRUE;
//GEOGRAPHICAL LATITUDE - you can see that on the geographical map
unsigned char lt1        = 45;
unsigned char lt2        = 49;
//GEOGRAPHICAL LONGITUDE - you can see that on the geographical map
unsigned char lg1        = 15;
unsigned char lg2        = 59;

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// END DATA FOR CREATING PRAYING TIMES
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

typedef struct sdate {
	float time;
	int day;
	int mon;
	int year;
	int dw;
	double nmtime;
} SDATE;

SDATE hd;
float tim[366][8];
double latitude,  longitude;
double asrShadowRatio, fajrInterval, fajrDepr;
double cosobl, sinobl, perigee, dmanom, anom0;
double c1, c2, delsid, sidtm0;
double timeZone = 1.00;
long stdow;
int leap, beginDayLight, endDayLight;
int fajrByInterval, fajrByMaxInterval;
int hasDayLt;
int hflag=0;
int EnvDef =0;
int cday, cmonth, cyear;

char workdir[512], rgch1[1024];
char *msname[12]= {"J A N U A R Y", "F E B R U A R Y", "M A R C H", "A P R I L", "M A Y", "J U N E", "J U L Y", "A U G U S T", "S E P T E M B E R", "O C T O B E R", "N O V E M B E R", "D E C E M B E R" };
char *dowl[]= { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char *dow[]= {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
char *mname[]= {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
char *hmname[] = {"MuHarram", "Safar", "Raby` al-awal", "Raby` al-THaany", "Jumaada al-awal", "Jumaada al-THaany", "Rajab", "SHa`baan", "RamaDHaan", "SHawwal", "Thw al-Qi`dah", "Thw al-Hijjah"};
char dirStrana[4] = {'E', 'W', 'N', 'S'};

SDATE *gdate(int y, int m, int d);
SDATE *hdate (int y, int m, int d);
SDATE *caldate(double julday);
double julianday(int year, int month, int day, float time);
double visible(long n, double *rjd);
double tmoonphase(long n, int nph);

int ndays(int m, int y);
int CalculatePrayingTimes(HWND hdlg);
int parseline(char *line, char *argv[], int maxargv);
int daynum(int d, int m, int y);
void derror(char *s);
void setdow(int y, int m, int d);
void makeSchedule(void);
void computeHours(int year, int first, int last);
void computeConstants(int year);
void dayLight(int year, int* leap, int hasDayLt, int* begin, int* finish);
void display(int first, int last, int startdate, int cd, int cm, int header);
void deg2dm(double degree, int *deg, int *min);
double noontime(int nday, double* coaltn);
double tempus(int nday, double coalt, double time0);
double qibla(void);
double deg2rad(double  degree);
double dm2deg(int degree, int minute);
double dms2deg(long degree, int min, double sec);
double hms2h(int hour, int min, double sec);


LRESULT CALLBACK PTProc(HWND, UINT, WPARAM, LPARAM);
LRESULT MsgDlgPrayingTimesInit(HWND, UINT, WPARAM, LPARAM);
LRESULT CmdPrayingTimesDone(HWND, UINT);

LRESULT CmdTimeZone(HWND, UINT);
LRESULT CmdHijriGregorianDate(HWND, UINT);

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PrayingTimesProc(HWND, UINT, WPARAM, LPARAM);


//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// MAIN WINODOW FUNCTIONS
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

#pragma argsused
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   char szAppName[]="PrayingTimes";
	MSG msg;
	HANDLE hAccelTable;
   WNDCLASS wc;


   if (!hPrevInstance) {
   	wc.style         = CS_HREDRAW | CS_VREDRAW; // Class style(s).
   	wc.lpfnWndProc   = (WNDPROC)WndProc;
   	wc.cbClsExtra    = 0;
   	wc.cbWndExtra    = 0;
   	hInst = wc.hInstance     = hInstance;
   	wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
   	wc.lpszMenuName  =  NULL;
   	wc.lpszClassName = szAppName;

   	if (!RegisterClass(&wc)) return 0;
   }
	GetCurrentDirectory(512, workdir);

   // Create a main window for this application instance.
   hwndMain = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
    	0, 0, 640, 480, NULL, NULL, hInstance, NULL);

   hwndButtonTimes = CreateWindow ("BUTTON", "Create Praying times", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
   	100, 100, 300, 30, hwndMain, (HMENU)IDM_PRAYING_TIMES, hInstance, NULL );

   hwndButtonDate = CreateWindow ("BUTTON", "Hijri Gregorian date", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
   	100, 200, 300, 30, hwndMain, (HMENU)IDM_HIJRI_GREGORIAN_DATE, hInstance, NULL );

   if (!hwndMain) {
      MessageBox(hwndMain, "Could not crate a window",NULL, MB_OK);
   	return FALSE;
   }
	ShowWindow (hwndMain, nCmdShow);
   UpdateWindow(hwndMain);
   hAccelTable = LoadAccelerators(hInstance, szAppName);

	while (GetMessage(&msg, NULL, 0, 0)) {
   	if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
      	TranslateMessage(&msg);  // Translates virtual key codes
      	DispatchMessage(&msg);   // Dispatches message to window
      }
    }
    return msg.wParam;  // Returns the value from PostQuitMessage
}


LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_PAINT: {
      	HDC hdc;
        	PAINTSTRUCT ps;
        	RECT rectClient;

        	hdc = BeginPaint(hwnd, &ps);
        	GetClientRect(hwnd, &rectClient);
      	SetBkMode(hdc, TRANSPARENT);
      	SetTextColor(hdc, RGB(0,0,0));
        	EndPaint(hwnd, &ps);
      }
      break;

      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
            case IDM_PRAYING_TIMES:
					DialogBox(hInst, "IDD_PTIMES", hwnd, (DLGPROC)PrayingTimesProc);
            	break;
            case IDM_HIJRI_GREGORIAN_DATE:
               CmdHijriGregorianDate(hwnd, message);
               break;
         	default:
	            break;
         }
      break;

      case WM_CLOSE:
        DestroyWindow(hwnd);
      break;

      case WM_DESTROY:
         PostQuitMessage (0);
      break;
      default:
      break;
   }
   return DefWindowProc(hwnd, message, wParam, lParam);
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// END MAIN WINODOW FUNCTIONS
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// PRAYING TIMES DIALOG BOX FUNCTIONS
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

LRESULT CALLBACK PrayingTimesProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_INITDIALOG:
      	MsgDlgPrayingTimesInit(hwnd, message, wParam, lParam);
	      break;

      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
            case IDB_TIMEZONE:
               CmdTimeZone(hwnd, IDB_TIMEZONE);
               break;
            case IDOK:
               CmdPrayingTimesDone(hwnd, IDOK);
               EndDialog(hwnd, TRUE);
               break;
            case IDCANCEL:
               CmdPrayingTimesDone(hwnd, IDCANCEL);
               EndDialog(hwnd, FALSE);
               break;
            case IDHELP:
               CmdPrayingTimesDone(hwnd, IDHELP);
               EndDialog(hwnd, FALSE);
               break;

         	default:
	            return FALSE;
         }
	      break;
      default:
   	   return FALSE;
   }
   return TRUE;
}
#pragma argsused
LRESULT MsgDlgPrayingTimesInit(HWND hdlg, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
   HWND hwid;
   int i, ix;
   char buffer[50];
   SYSTEMTIME  sTime;

   GetSystemTime(&sTime);

	cday = sTime.wDay;
   cmonth = sTime.wMonth;
   cyear = sTime.wYear;

   hwid = GetDlgItem(hdlg, IDC_COMBO_MONTH);
   for(i=1; i<13; i++) {
      wsprintf(buffer, "%d", i);
   	ix = SendMessage(hwid, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buffer);
      SendMessage(hwid, CB_SETITEMDATA, ix, i-1);
   }
	SendMessage(hwid, CB_SETCURSEL, sTime.wMonth-1, 0L);

   hwid = GetDlgItem(hdlg, IDC_COMBO_YEAR);
   for(i=sTime.wYear; i<sTime.wYear+20; i++) {
      wsprintf(buffer, "%d", i);
   	ix = SendMessage(hwid, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buffer);
      SendMessage(hwid, CB_SETITEMDATA, ix, i-sTime.wYear);
   }
	SendMessage(hwid, CB_SETCURSEL, 0, 0L);

	SendDlgItemMessage(hdlg, IDC_NORTH, BM_SETCHECK, north, 0L);
   SendDlgItemMessage(hdlg, IDC_SOUTH, BM_SETCHECK, south, 0L);
   SendDlgItemMessage(hdlg, IDC_EAST, BM_SETCHECK, east, 0L);
   SendDlgItemMessage(hdlg, IDC_WEST, BM_SETCHECK, west, 0L);

   SendDlgItemMessage(hdlg, IDC_DAYLIGHT_AVAL, BM_SETCHECK, dstAval, 0L);

   SetDlgItemInt(hdlg, IDE_LT1, lt1, TRUE);
   SetDlgItemInt(hdlg, IDE_LT2, lt2, TRUE);
   SetDlgItemInt(hdlg, IDE_LG1, lg1, TRUE);
   SetDlgItemInt(hdlg, IDE_LG2, lg2, TRUE);
   sprintf(strVarious, "%f", timeZone);
   strVarious[4] = '\0';
   SetDlgItemText(hdlg, IDE_TIMEZONE, strVarious);
//   SetDlgItemInt(hdlg, IDE_TIMEZONE, (int)timeZone, TRUE);

   SetDlgItemText(hdlg, IDE_NAME, nameTime);

	return TRUE;
}
#pragma argsused
LRESULT CmdPrayingTimesDone(HWND hdlg, UINT wCommand)
{
	switch (wCommand) {
		case IDOK:
         CalculatePrayingTimes(hdlg);
      	EndDialog(hdlg, FALSE);
      	break;

      case IDCANCEL:
      	EndDialog(hdlg, FALSE);
	      break;

		case IDHELP:
//         WinHelp(hdlg, HelpFileName, HELP_CONTEXT, HELP_CONTEXT);
	      break;

      default:
	      return FALSE;
	}
   return TRUE;
}
#pragma argsused
LRESULT CmdHijriGregorianDate(HWND hwnd, UINT wCommand)
{
	SDATE	*sd;
   SYSTEMTIME  sTime;
   char buf[10];

   GetSystemTime(&sTime);

   sd = hdate(sTime.wYear, sTime.wMonth, sTime.wDay);
   wsprintf(rgch1, "HIJRI / GREGORIAN DATE:\n%s %d, %s,", dow[sd->dw], sd->day, hmname[sd->mon-1]);
   if (sd->year>0) wsprintf(buf, " %d A.H.", sd->year);
   else wsprintf(buf, " %d B.H.", -sd->year);
   strcat(rgch1, buf);

   MessageBox(hwnd, rgch1, "Islam - Hijri Date", MB_OK | MB_ICONINFORMATION);
   return 0;
}
#pragma argsused
LRESULT CmdTimeZone(HWND hdlg, UINT wCommand)
{
   double zone;
   TIME_ZONE_INFORMATION tz;

   GetTimeZoneInformation(&tz);
   zone = (double)(tz.Bias/60);
   zone *= (double)(-1);
   timeZone = zone;

   sprintf(strVarious, "%f", timeZone);
   strVarious[4] = '\0';
   SetDlgItemText(hdlg, IDE_TIMEZONE, strVarious);
//   SetDlgItemInt(hdlg, IDE_TIMEZONE, (int)timeZone, TRUE);
	return 0;
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// END OF THE DIALOG BOX FUNCTIONS
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX




//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// CALCULATING PRAYING TIMES FUNCTIONS
// THIS CODE I DOWNLOADED FROM THE INTERNET AND MODIFY IT, WHICH OFFER THIS CODE FOR FREE
// MAY ALLAH SUBHANAHU WA TA'ALA REWARD THEY FOR THAT.
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

// THIS FUNCTION CALL WITH THE SUPPLIED INFORMATIONS AND TIME WILL BE WILL BE CREATED IN A SECIFIED FILE, INSHA'ALLAH.
// THAT IS MAIN FUNCTION WICH WILL CREATE A PRAYING TIMES FROM USERS INPUT, IN THIS CASE YOU MUST SUPLIED AN INFORMATIONS.
// AND THAT IS
// 1) NORTH-EAST=true, and like that in all cases
// 2) ltg1,ltg2,lg1,lg2 is longitude and langitude
// 3) time zone

int CalculatePrayingTimes(HWND hdlg)
{

   char tzbuf[10];
	int optA = 0, optT = 0, optM = 0;
	double  depr = 18.0, intvl = 90.0;
   BOOL decode;

	fajrByMaxInterval = 0; fajrByInterval = 0; fajrInterval = 1.5;
	fajrDepr = 18.0; asrShadowRatio = 1.0;

   if (SendDlgItemMessage(hdlg, IDC_NORTH, BM_GETCHECK, 0, 0L)) { north = TRUE; south = FALSE; }
   else { south = TRUE; north = FALSE; }

   if (SendDlgItemMessage(hdlg, IDC_EAST, BM_GETCHECK, 0, 0L)) { east = TRUE; west = FALSE; }
   else { west = TRUE; east = FALSE; }

   lt1 = (BYTE)GetDlgItemInt(hdlg, IDE_LT1, &decode, TRUE);
   lt2 = (BYTE)GetDlgItemInt(hdlg, IDE_LT2, &decode, TRUE);
   lg1 = (BYTE)GetDlgItemInt(hdlg, IDE_LG1, &decode, TRUE);
   lg2 = (BYTE)GetDlgItemInt(hdlg, IDE_LG2, &decode, TRUE);

//   timeZone = (BYTE)GetDlgItemInt(hdlg, IDE_TIMEZONE, &decode, TRUE);
   GetDlgItemText(hdlg, IDE_TIMEZONE, tzbuf, 10);
   timeZone = atof(tzbuf);

   GetDlgItemText(hdlg, IDE_NAME, nameTime, 100);

//   wsprintf(pozicija, "Zagreb   %d %d %c  %d %d %c  %d Y", lt1, lt2, dirStrana[west+2], lg1, lg2, dirStrana[south], timeZone);
//   MessageBox(hwndMain, pozicija, NULL, MB_OK);


	if (intvl <= 0) {
		if (optT) { fajrByInterval = 1; fajrInterval = intvl/60.0; }
		if (optM) { fajrByMaxInterval = 1; fajrInterval = intvl/60.0; }
		if (optA) { fajrByInterval = 0; fajrDepr = depr; }
   }

   if (hflag) hd = *hdate(cyear, cmonth, cday);

   hasDayLt = 1;
   if ((lt1 > 90) || (lt2 > 59)) derror("Illegal data for geographical latitude!\nMust be beetwen[0-90][0-59]");
   if ((lg1 > 90) || (lg2 > 59)) derror("Illegal data for geographical longitude!\nMust be beetwen[0-90][0-59]");

	latitude = deg2rad(dm2deg(lt1,lt2));
   if (south == TRUE) latitude = - latitude;
   longitude = deg2rad(dm2deg(lg1,lg2));
   if (east == TRUE) longitude = - longitude;
	makeSchedule();

   return 0;
}

//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

void derror(char *s)
{
	if (EnvDef) MessageBox(hwndMain, "Invalid PTLOC environment variable.", NULL, MB_OK | MB_ICONSTOP);
	else {
		MessageBox(hwndMain, s, NULL, MB_OK | MB_ICONSTOP);
   }
}
int daynum(int d, int m, int y)
{
	int i, dn;

	i=1; dn= --d;
	while (i<m) dn += (int)ndays(i++,y);
	return(dn);
}
void setdow(int y, int m, int d)
{
	stdow = ((long) (julianday(y,m,d, 0.0) + 1.5)) % 7;
}
void makeSchedule(void)
{
	int ndays0, ndays1;

   if (!hflag) {
      ndays0 = daynum(1, cmonth, cyear);
      ndays1 = ndays0+ndays(cmonth, cyear);
      computeHours(cyear, ndays0, ndays1);
      setdow(cyear, cmonth,1);
      display(ndays0, ndays1, 1,0, 0, 1);
   }
   else {
   	SDATE fd, ld;
      int cd, cm, ndays0, ndays1, sd=1, dh=1;

      fd = *gdate(cyear, cmonth,1);
      ld = *gdate(cyear, cmonth+1, 1);
      ld = *caldate(julianday(ld.year, ld.mon, ld.day, 0.0) - 1.0);

      ndays0 = daynum(fd.day, fd.mon, fd.year);
      setdow(fd.year,fd.mon,fd.day);
      cd = fd.day; cm = fd.mon;
      if (fd.mon != ld.mon) {
      	ndays1 = daynum(ndays(fd.mon,fd.year), fd.mon, fd.year) +1;
         computeHours(fd.year,ndays0,ndays1);
         display(ndays0, ndays1,sd,cd,cm, dh--);
         sd = ndays1 - ndays0 + 1;
         ndays0 = daynum(1, ld.mon, ld.year);
         cd = 1; cm = ld.mon;
      }
      ndays1 = daynum(ld.day, ld.mon, ld.year) + 1;
      computeHours(ld.year,ndays0,ndays1);
      display(ndays0,ndays1, sd, cd, cm, dh);
   }
}

/*
 * Computes times for range of days first..last-1.
 */

void computeHours(int year, int first, int last)
{
	double  coaltn,time0[6],coalt[6];
	register double t;
	register int  i,k,l;


	/* For perpetual, use 1994. (Need middle year of 4-year leap cycle */
	computeConstants(year==0 ? 1994 : year);

	/*  find beginning and ending days for daylight saving time */
	dayLight(year, &leap, hasDayLt, &beginDayLight, &endDayLight);


	/* Approximate times of fajr,shuruq,asr,maghrib,isha */
	time0[0] = 4.0;
	time0[1] = 6.0;
	time0[3] = 15.0;
	time0[4] = 18.0;
	time0[5] = 20.0;
	/* Coaltitudes of sun at fajr,shuruq,maghrib,isha */
	coalt[0] = deg2rad((double)(90+fajrDepr));
	coalt[1] = deg2rad(90.83);
	coalt[4] = coalt[1];
	coalt[5] = coalt[0];
	/* Get approximate times for the first day specified. */
	/* Later on, each day's times used as approximate times for next day */
	noontime(first,&coaltn);
	coalt[3] = atan(asrShadowRatio+tan(coaltn));
	time0[1] = (((t = tempus(first,coalt[1],time0[1])) < 24.0) ? t : 6.0);
	time0[3] = (((t = tempus(first,coalt[3],time0[3])) < 24.0) ? t : 15.0);
	time0[4] = (((t = tempus(first,coalt[4],time0[4])) < 24.0) ? t : 18.0);
	if (fajrByInterval) {
		time0[0] = time0[1] - fajrInterval;
		time0[5] = time0[4] + fajrInterval;
	} else {
		time0[0] = (((t = tempus(first,coalt[0],time0[0])) < 24.0) ? t : 4.0);
		time0[5] = (((t = tempus(first,coalt[5],time0[5])) < 24.0) ? t : 20.0);
	}
/*  compute times for the whole range of days */
	for (l=first, i=1; l<last; i++, l++) {
/*  for perpetual calendar, february 29 and march 1 have same times */
		k = l;
		if (l>59 && year==0) k = l-1;
		tim[l][2] = noontime(k+1,&coaltn);
		coalt[3] = atan(asrShadowRatio+tan(coaltn));
		time0[1] = (((tim[l][1] = t = tempus(k+1,coalt[1],time0[1]))
			    < 24.0) ? t : 6.0);
		time0[3] = (((tim[l][3] = t = tempus(k+1,coalt[3],time0[3]))
					< 24.0) ? t : 15.0);
		time0[4] = (((tim[l][4] = t = tempus(k+1,coalt[4],time0[4]))
					< 24.0) ? t : 18.0);
		if (fajrByInterval) {
			tim[l][0] = time0[0] = time0[1] - fajrInterval;
			tim[l][5] = time0[5] = time0[4] + fajrInterval;
		} else {
			time0[0] = (((tim[l][0] = t = tempus(k+1,coalt[0],time0[0]))
					< 24.0)  ? t : 4.0);
			time0[5] = (((tim[l][5] = t = tempus(k+1,coalt[5],time0[5]))
					< 24.0) ? t : 20.0);
		}
	}
/*  correct for daylight saving time (if necessary) */
	if (endDayLight !=0 && first<endDayLight) {
		i = beginDayLight-1;
		if (first>i) i=first;
		while (i<endDayLight && i<last) {
			for (k=0; k<6; k++) tim[i][k] += 1.0;
			i++;
		}
	}
}
void computeConstants(int year)
{

/*  ndays = time from 12 hr(noon), Jan 0, 1900 to 0 hr, Jan 0 of year */
/*  t = same in julian centuries (units of 36525 days) */
/*  obl = obliquity of ecliptic */
/*  perigee = sun's longitude at perigee  */
/*  eccy = earth's eccentricity */
/*  dmanom,delsid = daily motion (change) in */
/*                        sun's anomaly, sidereal time */
/*  anom0,sidtm0 = sun's mean anomaly, */
/*              sidereal time, all at 0 hr, jan 0 of year year */
/*  c1,c2 = coefficients in equation of center */

	register double         t;
	long                            ndays;
	double                          obl, eccy;

	ndays = ((long) (year-1900))*365+(year-1901)/4;
	t = (ndays-0.5)/36525.0;
	obl = deg2rad(dms2deg(23L,27,8.26)-dms2deg(0L,0,46.845)*t);
	cosobl = cos(obl);
	sinobl = sin(obl);
	eccy = 0.01675104-4.180e-5*t-1.26e-7*t*t;
	perigee = deg2rad(FMOD(dms2deg(281L,13,15.0)+dms2deg(1L,43,9.03)*t+
			  dms2deg(0L,0,1.63)*t*t,360.0));
	dmanom = deg2rad(dms2deg(35999L,2,59.10)/36525.0);
	anom0 = deg2rad(FMOD(dms2deg(358L,28,33.0)-dms2deg(0L,0,0.54)*t*t+
			FMOD(dms2deg(35999L,2,59.10)*t,360.0),360.0));
	delsid = hms2h(2400,3,4.542)/36525.0;
	sidtm0 = FMOD(hms2h(6,38,45.836)+FMOD(hms2h(2400,3,4.542)*t,24.0),24.0);
	c1 = eccy*(2-eccy*eccy/4);
	c2 = 5*eccy*eccy/4;
}

/*
 *  Double-duty function for leap year and Daylight Saving dates info.
 *  Finds whether year is leap (sets leap = 1 if yes, 0 if no).
 *  If hasDayLt is non-zero, then also computes the day numbers of the
 *  start and end of Daylight Savings Time.
 *  Sets begin = Day no. of the first Sunday of April, and
 *      finish = Day no. of the Saturday before the last Sunday of October.
 */

void dayLight(int year, int* leap, int hasDayLt, int* begin, int* finish)
{
	int m4,m1,jan0,napr1,noct31,apr1,oct31;

	m4 = year%400;
	m1 = year%100;
	*leap = (year%4 == 0 && m1 != 0) || m4 == 0;
	if (hasDayLt==0) {
	/* No adjustment for Daylight Saving Time (year zero for perpetual) */
		*begin = 367;
		*finish = 0;
		return;
	}
	if (year==0) {
	/* Daylight Saving Time in perpetual calendar. April 1 thru Oct 31 */
		*begin = 92; /* April 1, 31+29+31+1 */
		*finish = *begin+213; /* Oct 31, -1+30+31+30+31+31+30+31 */
		return;
	}
	/* Non-zero year. for annual calendar */
	/* jan0,apr1,oct31 = day of week on those dates (fri=0,sat=1,sun=2,...) */
	/* napr1,noct31 = Day no. in year on those dates */
	jan0 = (m4/100*124+1+m1+m1/4-*leap) % 7;
	napr1 = 91 + *leap; /* 31+28+*leap+31+1 */
	noct31 = 304 + *leap; /* 365+*leap-31-30 */
	apr1 = (napr1+jan0) % 7;
	oct31 = (noct31+jan0) % 7;
	*begin = napr1+2-apr1;
	if ( *begin < napr1 ) *begin += 7;
	*finish = noct31+2-oct31;
	if ( *finish > noct31 ) *finish -= 7;
	*finish = *finish-1;
}

/*
 * Place sun's coaltitude at noon in coaltn,
 * and return time of noon for day no. nday of year
 */

double noontime(int nday, double* coaltn)
{
/*  slong =  sun's true longitude at noon */
/*  ra = sun's right ascension, decl = sun's declination */
/*  ha = sun's hour angle west */
/*  locmt = local mean time of phenomenon */

	register double t;
	double longh,days,anomaly,slong,sinslong,ra,decl,locmt;

	longh = longitude*HPR;
	days = nday+(12.0+longh)/24.0;
	anomaly = anom0+dmanom*days;
	slong = perigee+anomaly+c1*sin(anomaly)+c2*sin(anomaly*2);
	sinslong = sin(slong);
	ra = atan2(cosobl*sinslong,cos(slong))*HPR;
	if (ra<0.0) ra += 24.0;
	decl = asin(sinobl*sinslong);
	locmt = ra-delsid*days-sidtm0;
	t = locmt+longh+timeZone;
	if (t<0.0) t += 24.0;
	if (t>24.0) t -= 24.0;
	*coaltn = FABS(latitude-decl);
	return(t);
}

/*
 * Returns time on day no. nday of year when sun's coaltitude is coalt.
 * If no such time, then returns a large number.
 *    time0 is approximate time of phenomenon
 */

double tempus(int nday, double coalt, double time0)
{
/*  slong =  true longitude */
/*  ra = sun's right ascension, sindcl = sin(sun's declination) */
/*  ha = sun's hour angle west */
/*  locmt = local mean time of phenomenon */

	double longh,days,anomaly,slong,sinslong,ra,sindcl,cosha,ha,locmt;
	register double t;

	longh = longitude*HPR;
	days = nday+(time0+longh)/24.0;
	anomaly = anom0+dmanom*days;
	slong = perigee+anomaly+c1*sin(anomaly)+c2*sin(anomaly*2);
	sinslong = sin(slong);
	ra = atan2(cosobl*sinslong,cos(slong))*HPR;
	if (ra<0.0) ra += 24.0;
	sindcl = sinobl*sinslong;
	cosha = (cos(coalt)-sindcl*sin(latitude))/
		       (sqrt(1.0-sindcl*sindcl)*cos(latitude));
	/*  if cos(ha)>1, then time cannot be evaluated */
	if (FABS(cosha)>1.0) return(1.0e7);
	ha = acos(cosha)*HPR;
	if (time0<12.0) ha = 24.0-ha;
	locmt = ha+ra-delsid*days-sidtm0;
	t = locmt+longh+timeZone;
	if (t<0.0) t += 24.0;
	if (t>24.0) t -= 24.0;
	return(t);
}

/*
 * Returns the direction of qibla in radians. Eastward from north is positive.
 */

double qibla(void)
{

	/*  lat0, long0 are Makkah's latitude and longitude in radians */
	double lat0 = 0.3739077, long0 = -0.69504828, dflong;

	dflong = longitude-long0;
	return( atan2(sin(dflong),
		      cos(latitude)*tan(lat0)-sin(latitude)*cos(dflong)) );
		      /*
		      cos(lat0)*tan(latitude)-sin(latitude)*cos(dflong)) );
		      */
}
double deg2rad(double  degree)
{
	return(degree*RPD);
}

double dm2deg(int degree, int minute)
{
	return((double) degree + minute/60.0);
}

void deg2dm(double degree, int *deg, int *min)
{
	double dabs;
	dabs = FABS(degree);
	*deg = dabs;
	*min = 60.0*(dabs - *deg) +0.5;
	if (*min>=60) {
		*min = 0;
		*deg += 1;
	}
}

double dms2deg(long degree, int min, double sec)
{
	return((double) degree + min/60.0 + sec/3600.0);
}

double hms2h(int hour, int min, double sec)
{
	return((double) hour + min/60.0 + sec/3600.0);
}


//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx conv xxxxxxxxxxxxxxx

double tmoonphase(long n, int nph)
{
	double jd, t, t2, t3, k, ma, sa, tf, xtra;
	k = n + nph/4.0;  t = k/1236.85;  t2 = t*t; t3 = t2*t;
	jd =  2415020.75933 + 29.53058868*k - 1.178e-4 * t2
	    - 1.55e-7 * t3
	    + 3.3e-4 * sin (RPD * (166.56 +132.87*t -0.009173*t2));

	/* Sun's mean anomaly */
	sa =  RPD * (359.2242 + 29.10535608*k - 3.33e-5 * t2 - 3.47e-6 * t3);

	/* Moon's mean anomaly */
	ma =  RPD * (306.0253 + 385.81691806*k + 0.0107306*t2 +1.236e-5 *t3);

	/* Moon's argument of latitude */
	tf = RPD * 2.0 * (21.2964 + 390.67050646*k -0.0016528*t2
		      -2.39e-6 * t3);

	/* should reduce to interval 0-1.0 before calculating further */
	if (nph==0 || nph==2)
		/* Corrections for New and Full Moon */
		xtra = (0.1734 - 0.000393*t) * sin(sa)
		      +0.0021*sin(sa*2)
		      -0.4068*sin(ma) +0.0161*sin(2*ma) -0.0004*sin(3*ma)
		      +0.0104*sin(tf)
		      -0.0051*sin(sa+ma) -0.0074*sin(sa-ma)
		      +0.0004*sin(tf+sa) -0.0004*sin(tf-sa)
		      -0.0006*sin(tf+ma) +0.0010*sin(tf-ma)
		      +0.0005*sin(sa+ 2*ma);
	else if (nph==1 || nph==3) {
		xtra = (0.1721 - 0.0004*t) * sin(sa)
		      +0.0021*sin(sa*2)
		      -0.6280*sin(ma) +0.0089*sin(2*ma) -0.0004*sin(3*ma)
		      +0.0079*sin(tf)
		      -0.0119*sin(sa+ma) -0.0047*sin(sa-ma)
		      +0.0003*sin(tf+sa) -0.0004*sin(tf-sa)
		      -0.0006*sin(tf+ma) +0.0021*sin(tf-ma)
		      +0.0003*sin(sa+ 2*ma) +0.0004*sin(sa-2*ma)
		      -0.0003*sin(2*sa+ma);
		if (nph==1)
			xtra = xtra +0.0028 -0.0004*cos(sa) +0.0003*cos(ma);
		else
			xtra = xtra -0.0028 +0.0004*cos(sa) -0.0003*cos(ma);
	} else {
		printf("tmoonphase: illegal phase number\n");
		exit(1);
	}
	/* convert from Ephemeris Time (ET) to (approximate)
	   Universal Time (UT) */
	jd += xtra - (0.41 +1.2053*t +0.4992*t2)/1440;
	return (jd);
}

#define TIMZ 3.0
#define MINAGE 13.5
#define SUNSET 19.5 /*approximate */
#define TIMDIF (SUNSET-MINAGE)
double visible(long n, double *rjd)
{
	double jd;
	float tf;
	long d;

	jd = tmoonphase(n,0);  *rjd = jd;
	d = jd;
	tf = (jd - d);
	if (tf<=0.5)  /*new moon starts in the afternoon */
		return(jd+1.0);
	/* new moon starts before noon */
	tf = (tf-0.5)*24 +TIMZ;  /* local time */
	if (tf>TIMDIF) return(jd+1.0);  /*age at sunset < min for visiblity*/
	return(jd);
}
double julianday(int year, int month, int day, float time)
{
	double jul;
	long m,y,ja;

	if (year<0) year++;
	if (month>2) {
		y = year; m =month;
	} else {
		y = year-1; m =month+12;
	}
	jul = ((double)y) * 365.25;
	if (y<1) jul -= 0.75;
	jul = ((long) jul) + ( (long) (30.6001*(m+1))) +day +time +1720994.5;
	if (year +month*1e-2 +(day+time)*1e-4 >= 1582.1015) {
		/* cross-over to Gregorian calendar */
		ja = 0.01*y;
		jul = jul +2 -ja + ((long) (0.25*ja));
	}
	return jul;
}
SDATE *caldate(double julday)
{
	static SDATE sd;
	long	z, alpha, a, b, c, d, e;
	double	f;

	julday += 0.5; z = julday; f = julday-z;
	if ( z<2299161L )  /* test whether to change to Gregorian cal */
		a = z;
	else {
		alpha = (z-1867216.25) / 36524.25;
		a     = z + 1 +alpha - alpha / 4;
	}
	b = a + 1524;  c = (b - 122.1) / 365.25; d = 365.25 * c;
	e = (b-d) / 30.6001;
	f += b -d - ((long) (30.6001*e));
	sd.day = f;
	sd.time = f-sd.day;
	sd.mon = (int)((e>13) ? e-13 : e-1);
	sd.year = (int)((sd.mon>2) ? c-4716 : c-4715);
	/*
	sd.dw = ((long) (julianday(sd.year,sd.mon, sd.day, 0.0) + 1.5)) % 7;
	*/
	sd.dw = ((int) (julday -sd.time + 1.1)) % 7;
	if ( sd.year<=0) sd.year--;
	return(&sd);
}
SDATE *hdate (int y, int m, int d)
{
	static SDATE h;
	double jd, mjd, rjd;
	long k, hm;

	jd = julianday(y,m,d,0.00);
	/* obtain first approx. of how many new moons since the beginning
	   of the year 1900 */
	k = 0.6 + (y + ((int) (m-0.5)) /12.0 + d/365.0 - 1900) *12.3685;
	do  {mjd = visible(k--, &rjd);} while (mjd>jd);  k++;
	/*first of the month is the following day*/
	hm = k -1048;
	h.year = (int)(1405 + (hm / 12));

	h.mon =  (int)((hm % 12) +1);
	if (hm !=0 && h.mon<=0) {h.mon +=12; h.year--; }
	if (h.year<=0) h.year--;
	h.day = jd -mjd +1.0;
	h.time = 0.5;
	h.dw = ((int) (jd+1.5)) % 7;
	return(&h);
}
#define NMONTHS  (1405*12+1)
SDATE *gdate(int y, int m, int d)
{
	double jd, rjd;
	long k;
	SDATE *sd;

	if (y<0) y++;
	k = m+ y*12 - NMONTHS;   /* # of months since 1/1/1405 */
	jd = visible(k+1048L, &rjd) +d;
	sd = caldate(jd);
	sd->nmtime = rjd;
	return (sd);
}
int ndays(int m, int y)
{
	static int  ndmnth[13] = {0,31,28,31,30,31,30,31,31,30,31,30,31};

	int nd = ndmnth[m];
	if (m==2 && (y%4==0 && (y<1582 || y%100!=0 || y%400==0))) nd++;
	return nd;
}
#pragma argsused
LRESULT CmdGregorianPT(HWND hwnd, WORD wCommand, WORD wNotify, HWND hwndCtrl)
{
	SDATE	*sd;
   SYSTEMTIME  sTime;
   char buf[10];

   GetSystemTime(&sTime);

   sd = hdate(sTime.wYear, sTime.wMonth, sTime.wDay);
   wsprintf(rgch1, "HIJRI / GREGORIAN DATE:\n%s %d, %s,", dow[sd->dw], sd->day, hmname[sd->mon-1]);
   if (sd->year>0) wsprintf(buf, " %d A.H.", sd->year);
   else wsprintf(buf, " %d B.H.", -sd->year);
   strcat(rgch1, buf);

   MessageBox(hwnd, rgch1, "Islam - Hijri Date", MB_OK | MB_ICONINFORMATION);
   return 0;
}
#pragma argsused
LRESULT CmdPTZone(HWND hdlg, WORD wCommand, WORD wNotify, HWND hwndCtrl)
{
   int zone;
   TIME_ZONE_INFORMATION tz;

   GetTimeZoneInformation(&tz);
   zone = tz.Bias/60;
   zone *= (-1);
   timeZone = zone;

   SetDlgItemInt(hdlg, IDE_TIMEZONE, (int)timeZone, TRUE);
	return 0;
}

void display(int first, int last, int startdate, int cd, int cm, int header)
{
   FILE *ft;
	int hour,minute;
	double    t;
	register int  i,j,l;
	double direc;
	int qibd, qibm, zoneH, zoneM;
	char sgnlat, sgnlng, sgnzon, sgnqib;
	SDATE	*sd;

   strcpy(rgch1, workdir);
   strcat(rgch1, "\\ptimes.dat");


	sgnlat = (south ? dirStrana[3] : dirStrana[2]);
	sgnlng = (west ? dirStrana[1] : dirStrana[0]);

	deg2dm(timeZone, &zoneH, &zoneM);
	sgnzon = (char)(timeZone<0 ? '-' : '+');

	direc = qibla() * DPR;
	deg2dm(direc, &qibd, &qibm);
	sgnqib = (direc<0 ? dirStrana[1] : dirStrana[0]);

	ft = fopen(rgch1, "w+");

	fprintf(ft, "For: %s at %s %2d, %4d\n", nameTime, mname[cmonth-1], cday, cyear);

   sd = hdate(cyear, cmonth, cday);
   fprintf(ft, "Gregorian/Hijri date: %s %d %s", dow[sd->dw], sd->day, hmname[sd->mon-1]);
   if (sd->year>0) fprintf(ft, " %d A.H.\n", sd->year);
   else fprintf(ft, " %d B.H.\n", -sd->year);

	fprintf(ft, "Latitude = %3d %02d' %c\n", lt1,lt2,sgnlat);
	fprintf(ft, "Longitude = %3d %02d' %c\n",lg1,lg2,sgnlng);
	fprintf(ft, "Time Zone = GMT %c%2dh",sgnzon,zoneH);
	if (zoneM) fprintf(ft, "%3dm\n",zoneM);
   else fprintf(ft, "\n");
	fprintf(ft, "Qiblah = %3d %02d' %c (From N)\n", qibd, qibm, sgnqib);


	if (header) {
	  fprintf(ft, "\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n");
	  fprintf(ft, "\n---------%s------------%s------------%s---------\n", mname[cmonth-1], mname[cmonth-1], mname[cmonth-1]);
	  fprintf(ft, "\nXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n");
	  fprintf(ft, "\n-----------------------------------------------------------------------\n");
	  fprintf(ft, "--------------Fajr-----SHorwwQ---DHuhr-----`ASr-----MaGHrib--`ISHaa'\n");
	  fprintf(ft, "Date Day------Dawn-----Sunrise---Noon----Afternoon--Sunset---Evening\n");
	  fprintf(ft, "-----------------------------------------------------------------------\n");
	}

	for (l=first, i=startdate; l<last; l++, i++) {
   	fprintf(ft, "%2d   ",i);
      fprintf(ft, "%3s",dowl[(int)stdow++]); stdow %= 7;
      for (j=0; j<6; j++) {
      	t = tim[l][j];
         if (fajrByMaxInterval) {
         	if (j==0 && (t>360.0 || t<0.0 || (tim[l][1]-t)> fajrInterval)) t = tim[l][1] - fajrInterval;
            if (j==5 && (t>360.0 || t<0.0 || (t-tim[l][4])> fajrInterval)) t = tim[l][4] + fajrInterval;
         }
         if (t>360.0) fprintf(ft, "       *  ");
         else if (t<0.0) fprintf(ft, "          ");
         else {
            hour = t;  minute = 60.0*(t-hour)+0.5;
            if (minute>=60) {
            	minute = 0;
               hour += 1;
            }
            if (hour>12) hour -= 12;
            fprintf(ft, "    %3d:%02d",hour,minute);
         }
      }
      if (hflag) fprintf(ft, "    %2d/%2d", cd++, cm);
      fprintf(ft, "\n");
   }
   fclose(ft);
   wsprintf(rgch1, "Praying times data was successfully saved in file:\n%s", SavingFileName);
   MessageBox(hwndMain, rgch1, NULL, MB_OK);
}


